/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config.data;

import frc.emul.config.data.CfgItemAddrSpace;
import frc.emul.config.data.IUnique;
import frc.emul.util.Utils;
import frc.util.IStream;
import frc.util.IStreamFactory;
import java.io.File;

public abstract class CfgItemCartridge
implements IUnique {
    protected final String id;
    protected final String name;
    private IStream cartridgeStream;
    public CfgItemAddrSpace cartridgeRAM;
    public boolean picked;
    public boolean built;
    public static final CfgItemCartridge EMPTY = CfgItemCartridge.newEmptyCartridge("EMPTY", "???");

    protected abstract IStream createCartridgeStream();

    public abstract boolean hasCartridge();

    public abstract boolean isZippedEntry();

    public abstract boolean isComposite();

    public abstract String getCartridgePath();

    public abstract String getCartridgeZipPath();

    protected CfgItemCartridge(String string, String string2) {
        this.id = string;
        this.name = string2;
    }

    public String toString() {
        return " " + this.getName() + " ";
    }

    public String getName() {
        return this.name;
    }

    public String getID() {
        return this.id;
    }

    public final IStream getCartridgeStream() {
        if (this.cartridgeStream == null && this.hasCartridge()) {
            this.cartridgeStream = this.createCartridgeStream();
        }
        return this.cartridgeStream;
    }

    public final void resetCartridgeStream() {
        this.cartridgeStream = null;
    }

    public final boolean hasCartridgeRam() {
        return this.cartridgeRAM != null && this.cartridgeRAM.size > 0;
    }

    static final IStream newFileStream(String string, String string2) {
        File file = Utils.getFile(string);
        if (CfgItemCartridge.isNotBlank(string2)) {
            return IStreamFactory.create(file, string2);
        }
        return IStreamFactory.create(file);
    }

    public static boolean isNotBlank(String string) {
        return string != null && string.trim().length() > 0;
    }

    public static final CfgItemCartridge newEmptyCartridge(String string, String string2) {
        return new EmptyCartridge(string, string2);
    }

    private static final class EmptyCartridge
    extends CfgItemCartridge {
        private EmptyCartridge(String string, String string2) {
            super(string, string2);
        }

        public IStream createCartridgeStream() {
            return null;
        }

        public String getCartridgePath() {
            return null;
        }

        public String getCartridgeZipPath() {
            return null;
        }

        public boolean hasCartridge() {
            return false;
        }

        public boolean isZippedEntry() {
            return false;
        }

        public boolean isComposite() {
            return false;
        }
    }
}

